# README

## Paper Information

- **Title:** Function regression using the forward forward training and inferring paradigm
- **Authors:** Anonymous authors
- **Conference:** ICLR 2026
---

## Overview

This repository contains the code used for the experiments performed in the paper **"Function regression using the forward forward training and inferring paradigm"** submitted to ICLR 2026. The codebase includes all scripts and files necessary to reproduce the main results reported in the paper.

---

## Contents
 


 


### Project File Overview


---

### 1D Models

- **1D_FF_Regression_fun1.py**  
  Reproduce $f_1$ function.  
  **Arguments:** `<no. of training points>` `<no. of epochs>`

- **1D_FF_Regression_fun2.py**  
  Reproduce $f_2$ function.  
  **Arguments:** `<no. of training points>` `<no. of epochs>`

- **1D_FF_Regression_fun3.py**  
  Reproduce $f_3$ function.  
  **Arguments:** `<no. of training points>` `<no. of epochs>`

- **1D_FF_Regression_Observation_1.py**  
  Observation 1 figure can be reproduced.  
  **Arguments:** None

- **1D_FF_loss_function_per_layer.py**  
  Reproduce Figure 12 in the main paper showing actual loss function.  
  **Arguments:** None

---

### 2D Models

- **2D_FF_Regression_fun4.py**  
  Reproduce $f_4$ function.  
  **Arguments:** None

- **2D_FF_Regression_fun5.py**  
  Reproduce $f_5$ function.  
  **Arguments:** None

---

### 3D Models

- **3D_FF_Regression_fun6.py**  
  Reproduce $f_6$ function.  
  **Arguments:** `<no. of epochs>`

- **3D_FF_Regression_fun7.py**  
  Reproduce $f_7$ function.  
  **Arguments:** `<no. of epochs>`

- **3D_FF_Regression_fun8.py**  
  Reproduce $f_8$ function.  
  **Arguments:** `<no. of epochs>`

---

### PNN (Physical Neural Network: taking input as parameters)

- **PNN_BP.py**  
  Reproduce results for neural network with input as parameters trained using Backpropagation.  
  **Arguments:** None

- **PNN_FF.py**  
  Reproduce results for neural network with input as parameters trained using Forward-Forward Paradigm.  
  **Arguments:** None

---

### Utilities and Others

- **FF_KAN_plot.py**  
  FF Paradigm used with Kolmogorov–Arnold Networks (KANs) to reproduce plots.  
  **Arguments:** None

- **Accuracy_improve_observation_3.py**  
  Reproduce plot for Observation 3 in the main paper.  
  **Arguments:** None


---

### Documentation & Config

- **README.md**  
  Provides a general overview and instructions for the project.  


- **requirements.txt**  
  Lists required Python packages and versions for the project.  

---

## Requirements

- Python version: [e.g., 3.12.1+]  
- Required packages:  
  ```bash
  pip install -r requirements.txt
To accelerate the training, recommended to use CUDA 12.6 enabled PyTorch library.
